﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Métiers;

namespace Catalogue
{
    public partial class Accueil : Form
    {

        public static string groupe;  //Pour récupérer le nom du groupe et la famille sélectionné
        public static string famille;
        public static string nomMedicament;

        public static bool fermerAccueil = false;

        public static bool etatBoutonOkRecherche;

        public static FamilleMedicament familleMedicament = new FamilleMedicament();
        public static Medicament medicament = new Medicament();
        public Accueil()
        {
            InitializeComponent();
        }

        private void btnQuitter_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }


        private void Accueil_Load(object sender, EventArgs e)
        {

            groupe = Convert.ToString(Métiers.Accueil.listeGroupe().Rows[0]);

            // Remplissage de la liste des groupes
            lstGroupe.DataSource = Métiers.Accueil.listeGroupe();
            lstGroupe.DisplayMember = Métiers.Accueil.listeGroupe().Columns[0].ToString();
        }



        private void lstGroupe_SelectedIndexChanged(object sender, EventArgs e)
        {
            DataRowView drvGroupe = (DataRowView)lstGroupe.SelectedItem;
            groupe = drvGroupe.Row[0].ToString();

            // Remplissage de la liste des familles 
            lstFamille.DataSource = Métiers.Accueil.listeFamille(groupe);
            lstFamille.DisplayMember = Métiers.Accueil.listeFamille(groupe).Columns[0].ToString();

            
            
            DataTable table = Métiers.Medicament.nomMedicamentGroupe(groupe);
            dgvRecherche.DataSource = table;
        }









        private void lstFamille_DoubleClick(object sender, EventArgs e)
        {
            DataRowView drvFamille = (DataRowView)lstFamille.SelectedItem;
            famille = drvFamille.Row[0].ToString();
            
            //Ouverture du form FamilleMedicament
            FamilleMedicament familleMedicament = new FamilleMedicament();
            familleMedicament.Show();
            

        }








        private void txtRecherche_TextChanged(object sender, EventArgs e)
        {
            string nom = txtRecherche.Text;
            dgvRecherche.DataSource = Métiers.Accueil.barreRecherche(nom);
        }







        private void dgvRecherche_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            nomMedicament = dgvRecherche.CurrentRow.Cells[0].Value.ToString();
            Métiers.Medicament.medicament(Accueil.nomMedicament);

            etatBoutonOkRecherche = true;

            txtRecherche.Text = "";



            Medicament medicament = new Medicament();
            medicament.Show(this);
        }





        private void txtRecherche_Click(object sender, EventArgs e)
        {
            lstFamille.SelectedIndex = 0;
            lstGroupe.SelectedIndex = 0;
            string nom = "";
            dgvRecherche.DataSource = Métiers.Accueil.barreRecherche(nom);
        }




        private void dgvRecherche_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            //pour avoir le chemin d'affiché
            /*string nomMedicament2 = dgvRecherche.CurrentRow.Cells[0].Value.ToString();

            groupe = Métiers.Medicament.groupeFamilleMedicament(nomMedicament2).Rows[0]["fGroupe"].ToString();
            int indexGroupe = lstGroupe.FindStringExact(groupe);
            lstGroupe.SelectedIndex = indexGroupe;

            famille = Métiers.Medicament.groupeFamilleMedicament(nomMedicament2).Rows[0]["fLibelle"].ToString();
            int indexFamille = lstFamille.FindStringExact(famille);
            lstFamille.SelectedIndex = indexFamille;*/
        }
    }
}
